<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetworkManagement;

class DropInfo extends \Google\Model
{
  /**
   * @var string
   */
  public $cause;
  /**
   * @var string
   */
  public $destinationIp;
  /**
   * @var string
   */
  public $region;
  /**
   * @var string
   */
  public $resourceUri;
  /**
   * @var string
   */
  public $sourceIp;

  /**
   * @param string
   */
  public function setCause($cause)
  {
    $this->cause = $cause;
  }
  /**
   * @return string
   */
  public function getCause()
  {
    return $this->cause;
  }
  /**
   * @param string
   */
  public function setDestinationIp($destinationIp)
  {
    $this->destinationIp = $destinationIp;
  }
  /**
   * @return string
   */
  public function getDestinationIp()
  {
    return $this->destinationIp;
  }
  /**
   * @param string
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * @param string
   */
  public function setResourceUri($resourceUri)
  {
    $this->resourceUri = $resourceUri;
  }
  /**
   * @return string
   */
  public function getResourceUri()
  {
    return $this->resourceUri;
  }
  /**
   * @param string
   */
  public function setSourceIp($sourceIp)
  {
    $this->sourceIp = $sourceIp;
  }
  /**
   * @return string
   */
  public function getSourceIp()
  {
    return $this->sourceIp;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DropInfo::class, 'Google_Service_NetworkManagement_DropInfo');
